<?php

namespace App\Console\Commands;
use Illuminate\Console\Command;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Models\Subscription;

class PlanExpiry extends Command
{
    protected $signature = 'expired:plan';
    protected $description = 'Expired Plans';

    public function handle()
    {
        $today = Carbon::today();

        $expiredSubscriptions = Subscription::where('end_date', '<', $today)
            ->where('status', '!=', 'expired')
            ->get();

        foreach ($expiredSubscriptions as $subscription) {
            $subscription->status = 'expired';
            $subscription->save();
        }
    }
}